<?php
/**
 * Change Status
 *
 * @package     AutomatorWP\Integrations\FluentCRM\Actions\Change_Status
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_FluentCRM_Change_Status extends AutomatorWP_Integration_Action {

    public $integration = 'fluentcrm';
    public $action = 'fluentcrm_change_status';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Change contact status', 'automatorwp-pro' ),
            'select_option'     => __( 'Change contact <strong>status</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Status. */
            'edit_label'        => sprintf( __( 'Change contact status to %1$s', 'automatorwp-pro' ), '{status}' ),
            /* translators: %1$s: Status. */
            'log_label'         => sprintf( __( 'Change contact status to %1$s', 'automatorwp-pro' ), '{status}' ),
            'options'           => array(
                'status' => array(
                    'from' => __( 'status', 'automatorwp-pro' ),
                    'fields' => array(
                        'email' => array(
                            'name' => __( 'Email:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'desc' => __( 'The contact email. Leave blank to set the user who completed the automation.', 'automatorwp-buddyboss' ),
                            'required' => true,
                        ),
                        'status' => array(
                            'name' => __( 'Status:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'subscribed'    => __( 'Subscribed', 'automatorwp-pro' ),
                                'pending'       => __( 'Pending', 'automatorwp-pro' ),
                                'unsubscribed'  => __( 'Unsubscribed', 'automatorwp-pro' ),
                                'bounced'       => __( 'Bounced', 'automatorwp-pro' ),
                                'complained'    => __( 'Complained', 'automatorwp-pro' ),
                            ),
                            'default' => 'subscribed'
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $this->result = '';

        if ( empty( $action_options['email'] ) ) {
            $user = get_user_by ( 'ID', $user_id );
            $contact_email = $user->user_email;
        } else {
            $contact_email = $action_options['email'];
        }
        
        $subscriber = new FluentCrm\App\Models\Subscriber();
        $contact_obj = new FluentCrm\App\Api\Classes\Contacts($subscriber);
        $contact_exists = $contact_obj->getContact( $contact_email );

        if ( empty ( $contact_exists ) ) {
            $this->result = sprintf( __( '%s contact does not exist.', 'automatorwp-pro' ), $contact_email );
            return;
        }
        
        $subscriber_data = array(
            'email'     => $contact_email,
            'status'    => $action_options['status'],
        );

        

        // Update or create the new subscriber
        $subscriber->updateOrCreate( $subscriber_data, true );

        $this->result = sprintf( __( '%s status has been updated to %s', 'automatorwp-pro' ), $contact_email, $action_options['status'] );

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_FluentCRM_Change_Status();